/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class CodeBlock {
    protected String fClassName;
    protected Object fTargetObject;
    protected String fMethodName = null;
    protected Vector fParameter = new Vector();
    protected Vector fParameterClasses = new Vector();
    protected Class fClassReference = null;
    protected Exception fException = null;
    protected ClassLoader fClassLoader;

    public CodeBlock() {
    }

    public CodeBlock(Object object) {
        this();
        this.fClassReference = object.getClass();
        this.fTargetObject = object;
    }

    public CodeBlock(Object object, String methodName) {
        this(object);
        this.fMethodName = methodName;
    }

    public CodeBlock(String className) {
        this();
        this.fClassName = className;
    }

    public CodeBlock(String className, String methodName) {
        this();
        this.fClassName = className;
        this.fMethodName = methodName;
    }

    public void addParameter(char c) {
        this.fParameter.addElement(new Character(c));
        this.fParameterClasses.addElement(Character.TYPE);
    }

    public void addParameter(float f) {
        this.fParameter.addElement(new Float(f));
        this.fParameterClasses.addElement(Float.TYPE);
    }

    public void addParameter(int i) {
        this.fParameter.addElement(new Integer(i));
        this.fParameterClasses.addElement(Integer.TYPE);
    }

    public void addParameter(Object parameter) {
        this.fParameterClasses.addElement(parameter.getClass());
        this.fParameter.addElement(parameter);
    }

    public void addParameter(String className, Object parameter) throws NoSuchMethodException {
        try {
            this.fParameterClasses.addElement(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            this.throwException(e, "The Class with the specified name could not be found.");
        }
        this.fParameter.addElement(parameter);
    }

    public void addParameter(boolean b) {
        this.fParameter.addElement(new Boolean(b));
        this.fParameterClasses.addElement(Boolean.TYPE);
    }

    public void clearParameters() {
        this.fParameterClasses = new Vector();
        this.fParameter = new Vector();
    }

    public Object execConstructor() throws NoSuchMethodException {
        Object returnValue = null;
        try {
            returnValue = this.getConstructor().newInstance(this.getParameterArray());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            this.throwException(e, "The class with the specified Name is not accessible (probably in an other package an not public).");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            this.throwException(e, "The specified Class could not be instantiated (probable it is an interface or an abstract class)");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            e.getTargetException().printStackTrace();
            this.throwException(e, "An Exception occured in the invoked construrctor.");
        }
        return returnValue;
    }

    public Object execMethod() throws NoSuchMethodException {
        Object returnValue = null;
        try {
            returnValue = this.getMethodReference(this.fMethodName).invoke(this.fTargetObject, this.getParameterArray());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.throwException(e, "An Exception occured in the invoked construrctor.");
        }
        catch (IllegalAccessException e) {
            this.throwException(e, "The class with the specified Name is not accessible (probably in an other package an not public).");
        }
        return returnValue;
    }

    public Class[] getClassArray() {
        Object[] parameterClassesArray = new Class[this.fParameter.size()];
        this.fParameterClasses.copyInto(parameterClassesArray);
        return parameterClassesArray;
    }

    public Class getClassReference() throws NoSuchMethodException {
        if (this.fClassReference == null) {
            try {
                this.fClassReference = this.fClassLoader != null ? this.fClassLoader.loadClass(this.fClassName) : Class.forName(this.fClassName);
            }
            catch (ClassNotFoundException e) {
                this.throwException(e, "The class with the specified name '" + this.fClassName + "' could not be found.");
            }
        }
        return this.fClassReference;
    }

    public Constructor getConstructor() throws NoSuchMethodException {
        Constructor constructor = null;
        boolean loop = true;
        Class[] classArr = this.getClassArray();
        int classIdx = 0;
        while (loop) {
            try {
                constructor = this.getClassReference().getConstructor(classArr);
                loop = false;
            }
            catch (NoSuchMethodException e) {
                boolean loop2 = true;
                while (loop2) {
                    classArr[classIdx] = classArr[classIdx].getSuperclass();
                    if (classArr[classIdx] == null) {
                        classArr[classIdx] = this.getClassArray()[classIdx];
                        if (++classIdx != classArr.length) continue;
                        loop = false;
                        loop2 = false;
                        continue;
                    }
                    loop2 = false;
                }
            }
        }
        if (constructor == null) {
            NoSuchMethodException e = new NoSuchMethodException("Kein passender Konstruktor gefunden:\n" + this.fClassName + "(" + this.fParameterClasses + ")");
            this.fException = e;
            throw e;
        }
        return constructor;
    }

    public Exception getInternalException() {
        return this.fException;
    }

    public Method getMethodReference(String methodName) throws NoSuchMethodException {
        Method method = null;
        boolean loop = true;
        Class[] classArr = this.getClassArray();
        int classIdx = 0;
        while (loop) {
            try {
                method = this.getClassReference().getMethod(methodName, classArr);
                loop = false;
            }
            catch (NoSuchMethodException e) {
                boolean loop2 = true;
                while (loop2) {
                    classArr[classIdx] = classArr[classIdx].getSuperclass();
                    if (classArr[classIdx] == null) {
                        classArr[classIdx] = this.getClassArray()[classIdx];
                        if (++classIdx != classArr.length) continue;
                        loop = false;
                        loop2 = false;
                        continue;
                    }
                    loop2 = false;
                }
            }
        }
        if (method == null) {
            NoSuchMethodException e = new NoSuchMethodException("Keine passende Methode gefunden:\n" + methodName + "(" + this.fParameterClasses + ")");
            this.fException = e;
            throw e;
        }
        return method;
    }

    public Object[] getParameterArray() {
        Object[] parameterArray = new Object[this.fParameter.size()];
        this.fParameter.copyInto(parameterArray);
        return parameterArray;
    }

    public void setMethod(String methodName) {
        this.fMethodName = methodName;
    }

    private void throwException(Exception e, String message) throws NoSuchMethodException {
        this.fException = e;
        throw new NoSuchMethodException(message);
    }

    public ClassLoader getClassLoader() {
        return this.fClassLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.fClassLoader = loader;
    }
}

